var comps = [];
var matrix = [];

function resetComps() {
    comps = [];
}

function resetMatrix() {
    matrix = [];
    for (var i = 0; i < 100; i++) {
        var mxitem = [];
        for (var j = 0; j < 100; j++) {
            mxitem.push(0);
        }
        matrix.push(mxitem);
    }
}

function createCompsCircle(centerX, centerY, radius, units) {
    var unitsPlaced = 0;
    for (var angle = 0; angle < 360; angle++) {
        var rad = angle * (Math.PI / 180);
        var xrad = radius * Math.cos(rad);
        var yrad = radius * Math.sin(rad);
        var x = 0;
        var y = 0;
        /*if (xrad > 0) { x = Math.ceil(centerX + xrad);}
        else { x = Math.floor(centerX + xrad);}
        if (yrad > 0) { y = Math.ceil(centerY + yrad);}
        else { y = Math.floor(centerY + yrad);}*/
        x = Math.round(centerX + xrad);
        y = Math.round(centerY + yrad);
        if (x < 0 || x >= 20) { continue; }
        if (unitsPlaced >= units * 2) { break; }
        if (matrix[x][y]) { continue; }
        var xNeighbour = matrix[x + 1][y] || matrix[x - 1][y];
        var yNeighbour = matrix[x][y + 1] || matrix[x][y - 1];
        if (xNeighbour && yNeighbour) { continue; }
        matrix[x][y] = 1;
        unitsPlaced++;
        if (unitsPlaced % 2) {
            comps.push(addComputer(x, y));
        }
    }
}

function closestTwo(n) {
    if (n < 1) { return 1 }
    var power = 1;
    while (power < n) { power *= 2; }
    return power;
}

function joinComps(comps, hub) {
    hub.setSocketsCount(closestTwo(comps.length));

    for (var i = 0; i < comps.length; i++) {
        addConnection(comps[i], hub, "eth0", "LAN" + (i + 1));
        comps[i].setIp("eth0", "192.168.0." + (i + 1));
        comps[i].setMask("eth0", "255.255.255.0");
    }
}

resetComps();
resetMatrix();
createCompsCircle(5, 7, 4, 13);
var hub = addHub(5, 7);
joinComps(comps, hub);

resetComps();
resetMatrix();
createCompsCircle(15, 7, 4, 13);
var hub = addSwitch(15, 7);
joinComps(comps, hub);