import oracledb
import sys

try:
    connection = oracledb.connect(user="student", password="student", dsn="127.0.0.1:1521/student")
    print("Connection successful!")

    cursor = connection.cursor()
    query = 'SELECT "surname" FROM "students_se" WHERE "birth_year" < 2005'
    cursor.execute(query)
    results = cursor.fetchall()

    print("\nStudents born before 2005:")
    for row in results:
        print(f"- {row[0]}") # row[0] is the surname

    cursor.close()
    connection.close()

except oracledb.Error as error:
    print(f"Database error: {error}")
    sys.exit(1)